package main

import (
	"github.com/veandco/go-sdl2/sdl"
	"github.com/veandco/go-sdl2/ttf"
)

type Text struct {
	font  *ttf.Font
	text  string
	color sdl.Color
}

func NewText(font *ttf.Font, text string, color sdl.Color) *Text {
	t := new(Text)
	t.font = font
	t.text = text
	t.color = color
	return t
}

func (t *Text) DrawCenter(renderer *sdl.Renderer, x, y int32, alpha uint8) {
	t.color.A = alpha
	surface, err := t.font.RenderUTF8Blended(t.text, t.color)
	if err != nil {
		panic(err)
	}
	texture, err := renderer.CreateTextureFromSurface(surface)
	if err != nil {
		panic(err)
	}

	renderer.Copy(texture, nil, &sdl.Rect{
		X: x - (surface.W / 2),
		Y: y - (surface.H / 2),
		W: surface.W,
		H: surface.H,
	})
	texture.Destroy()
	surface.Free()
}
